<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasLegalStructureRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $apeCode;

    /**
     * @var string|null
     */
    protected $legalCode;

    /**
     * @var string|null
     */
    protected $legalForm;

    /**
     * Postal Address - Patch Request Model.
     *
     * @var SchemasPostalAddressRequest|null
     */
    protected $headQuarterAddress;

    /**
     * @var string|null
     */
    protected $socialReason;

    /**
     * @var string|null
     */
    protected $tradeName;

    /**
     * @var string|null
     */
    protected $vatIntraCommunityNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getApeCode(): ?string
    {
        return $this->apeCode;
    }

    public function setApeCode(?string $apeCode): self
    {
        $this->initialized['apeCode'] = true;
        $this->apeCode = $apeCode;

        return $this;
    }

    public function getLegalCode(): ?string
    {
        return $this->legalCode;
    }

    public function setLegalCode(?string $legalCode): self
    {
        $this->initialized['legalCode'] = true;
        $this->legalCode = $legalCode;

        return $this;
    }

    public function getLegalForm(): ?string
    {
        return $this->legalForm;
    }

    public function setLegalForm(?string $legalForm): self
    {
        $this->initialized['legalForm'] = true;
        $this->legalForm = $legalForm;

        return $this;
    }

    /**
     * Postal Address - Patch Request Model.
     */
    public function getHeadQuarterAddress(): ?SchemasPostalAddressRequest
    {
        return $this->headQuarterAddress;
    }

    /**
     * Postal Address - Patch Request Model.
     */
    public function setHeadQuarterAddress(?SchemasPostalAddressRequest $headQuarterAddress): self
    {
        $this->initialized['headQuarterAddress'] = true;
        $this->headQuarterAddress = $headQuarterAddress;

        return $this;
    }

    public function getSocialReason(): ?string
    {
        return $this->socialReason;
    }

    public function setSocialReason(?string $socialReason): self
    {
        $this->initialized['socialReason'] = true;
        $this->socialReason = $socialReason;

        return $this;
    }

    public function getTradeName(): ?string
    {
        return $this->tradeName;
    }

    public function setTradeName(?string $tradeName): self
    {
        $this->initialized['tradeName'] = true;
        $this->tradeName = $tradeName;

        return $this;
    }

    public function getVatIntraCommunityNumber(): ?string
    {
        return $this->vatIntraCommunityNumber;
    }

    public function setVatIntraCommunityNumber(?string $vatIntraCommunityNumber): self
    {
        $this->initialized['vatIntraCommunityNumber'] = true;
        $this->vatIntraCommunityNumber = $vatIntraCommunityNumber;

        return $this;
    }
}
