<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ScheduleResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var OpeningPeriodResponse[]|null
     */
    protected $monday;

    /**
     * @var OpeningPeriodResponse[]|null
     */
    protected $tuesday;

    /**
     * @var OpeningPeriodResponse[]|null
     */
    protected $wednesday;

    /**
     * @var OpeningPeriodResponse[]|null
     */
    protected $thursday;

    /**
     * @var OpeningPeriodResponse[]|null
     */
    protected $friday;

    /**
     * @var OpeningPeriodResponse[]|null
     */
    protected $saturday;

    /**
     * @var OpeningPeriodResponse[]|null
     */
    protected $sunday;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return OpeningPeriodResponse[]|null
     */
    public function getMonday(): ?array
    {
        return $this->monday;
    }

    /**
     * @param OpeningPeriodResponse[]|null $monday
     */
    public function setMonday(?array $monday): self
    {
        $this->initialized['monday'] = true;
        $this->monday = $monday;

        return $this;
    }

    /**
     * @return OpeningPeriodResponse[]|null
     */
    public function getTuesday(): ?array
    {
        return $this->tuesday;
    }

    /**
     * @param OpeningPeriodResponse[]|null $tuesday
     */
    public function setTuesday(?array $tuesday): self
    {
        $this->initialized['tuesday'] = true;
        $this->tuesday = $tuesday;

        return $this;
    }

    /**
     * @return OpeningPeriodResponse[]|null
     */
    public function getWednesday(): ?array
    {
        return $this->wednesday;
    }

    /**
     * @param OpeningPeriodResponse[]|null $wednesday
     */
    public function setWednesday(?array $wednesday): self
    {
        $this->initialized['wednesday'] = true;
        $this->wednesday = $wednesday;

        return $this;
    }

    /**
     * @return OpeningPeriodResponse[]|null
     */
    public function getThursday(): ?array
    {
        return $this->thursday;
    }

    /**
     * @param OpeningPeriodResponse[]|null $thursday
     */
    public function setThursday(?array $thursday): self
    {
        $this->initialized['thursday'] = true;
        $this->thursday = $thursday;

        return $this;
    }

    /**
     * @return OpeningPeriodResponse[]|null
     */
    public function getFriday(): ?array
    {
        return $this->friday;
    }

    /**
     * @param OpeningPeriodResponse[]|null $friday
     */
    public function setFriday(?array $friday): self
    {
        $this->initialized['friday'] = true;
        $this->friday = $friday;

        return $this;
    }

    /**
     * @return OpeningPeriodResponse[]|null
     */
    public function getSaturday(): ?array
    {
        return $this->saturday;
    }

    /**
     * @param OpeningPeriodResponse[]|null $saturday
     */
    public function setSaturday(?array $saturday): self
    {
        $this->initialized['saturday'] = true;
        $this->saturday = $saturday;

        return $this;
    }

    /**
     * @return OpeningPeriodResponse[]|null
     */
    public function getSunday(): ?array
    {
        return $this->sunday;
    }

    /**
     * @param OpeningPeriodResponse[]|null $sunday
     */
    public function setSunday(?array $sunday): self
    {
        $this->initialized['sunday'] = true;
        $this->sunday = $sunday;

        return $this;
    }
}
