<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PrincipalPut extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * E-Mail of the person.
     *
     * @var string|null
     */
    protected $email;

    /**
     * Last name of the person.
     *
     * @var string|null
     */
    protected $lastname;

    /**
     * First name of the person.
     *
     * @var string|null
     */
    protected $firstname;

    /**
     * Locale to use. If not provided, detected during account validation.
     *
     * @var string|null
     */
    protected $locale;

    /**
     * Timezone to use. If not provided, detected during account validation.
     *
     * @var string|null
     */
    protected $timezone;

    /**
     * Birth date if the principal a person.
     *
     * @var \DateTime|null
     */
    protected $birthDate;

    /**
     * Postcode of birth, if principal is a person.
     *
     * @var string|null
     */
    protected $birthPostCode;

    /**
     * City of birth, if principal is a person.
     *
     * @var string|null
     */
    protected $birthCity;

    /**
     * Country of birth, if principal is a person. ISO 3 letters.
     *
     * @var string|null
     */
    protected $birthCountry;

    /**
     * @var PostalAddress
     */
    protected $mainAddress;

    /**
     * @var PrincipalPutPhoneNumbersItem[]
     */
    protected $phoneNumbers;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * E-Mail of the person.
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * E-Mail of the person.
     */
    public function setEmail(?string $email): self
    {
        $this->initialized['email'] = true;
        $this->email = $email;

        return $this;
    }

    /**
     * Last name of the person.
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * Last name of the person.
     */
    public function setLastname(?string $lastname): self
    {
        $this->initialized['lastname'] = true;
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * First name of the person.
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * First name of the person.
     */
    public function setFirstname(?string $firstname): self
    {
        $this->initialized['firstname'] = true;
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * Locale to use. If not provided, detected during account validation.
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * Locale to use. If not provided, detected during account validation.
     */
    public function setLocale(?string $locale): self
    {
        $this->initialized['locale'] = true;
        $this->locale = $locale;

        return $this;
    }

    /**
     * Timezone to use. If not provided, detected during account validation.
     */
    public function getTimezone(): ?string
    {
        return $this->timezone;
    }

    /**
     * Timezone to use. If not provided, detected during account validation.
     */
    public function setTimezone(?string $timezone): self
    {
        $this->initialized['timezone'] = true;
        $this->timezone = $timezone;

        return $this;
    }

    /**
     * Birth date if the principal a person.
     */
    public function getBirthDate(): ?\DateTime
    {
        return $this->birthDate;
    }

    /**
     * Birth date if the principal a person.
     */
    public function setBirthDate(?\DateTime $birthDate): self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;

        return $this;
    }

    /**
     * Postcode of birth, if principal is a person.
     */
    public function getBirthPostCode(): ?string
    {
        return $this->birthPostCode;
    }

    /**
     * Postcode of birth, if principal is a person.
     */
    public function setBirthPostCode(?string $birthPostCode): self
    {
        $this->initialized['birthPostCode'] = true;
        $this->birthPostCode = $birthPostCode;

        return $this;
    }

    /**
     * City of birth, if principal is a person.
     */
    public function getBirthCity(): ?string
    {
        return $this->birthCity;
    }

    /**
     * City of birth, if principal is a person.
     */
    public function setBirthCity(?string $birthCity): self
    {
        $this->initialized['birthCity'] = true;
        $this->birthCity = $birthCity;

        return $this;
    }

    /**
     * Country of birth, if principal is a person. ISO 3 letters.
     */
    public function getBirthCountry(): ?string
    {
        return $this->birthCountry;
    }

    /**
     * Country of birth, if principal is a person. ISO 3 letters.
     */
    public function setBirthCountry(?string $birthCountry): self
    {
        $this->initialized['birthCountry'] = true;
        $this->birthCountry = $birthCountry;

        return $this;
    }

    public function getMainAddress(): PostalAddress
    {
        return $this->mainAddress;
    }

    public function setMainAddress(PostalAddress $mainAddress): self
    {
        $this->initialized['mainAddress'] = true;
        $this->mainAddress = $mainAddress;

        return $this;
    }

    /**
     * @return PrincipalPutPhoneNumbersItem[]
     */
    public function getPhoneNumbers(): array
    {
        return $this->phoneNumbers;
    }

    /**
     * @param PrincipalPutPhoneNumbersItem[] $phoneNumbers
     */
    public function setPhoneNumbers(array $phoneNumbers): self
    {
        $this->initialized['phoneNumbers'] = true;
        $this->phoneNumbers = $phoneNumbers;

        return $this;
    }
}
