<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class InvoiceResponseItemReceiverInformation extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $legalCode;

    /**
     * @var string|null
     */
    protected $vatIntraCommunityNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getLegalCode(): string
    {
        return $this->legalCode;
    }

    public function setLegalCode(string $legalCode): self
    {
        $this->initialized['legalCode'] = true;
        $this->legalCode = $legalCode;

        return $this;
    }

    public function getVatIntraCommunityNumber(): ?string
    {
        return $this->vatIntraCommunityNumber;
    }

    public function setVatIntraCommunityNumber(?string $vatIntraCommunityNumber): self
    {
        $this->initialized['vatIntraCommunityNumber'] = true;
        $this->vatIntraCommunityNumber = $vatIntraCommunityNumber;

        return $this;
    }
}
