<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ContractRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var IdRequest[]
     */
    protected $veterinaryEstablishmentServiceSubscriptions;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return IdRequest[]
     */
    public function getVeterinaryEstablishmentServiceSubscriptions(): array
    {
        return $this->veterinaryEstablishmentServiceSubscriptions;
    }

    /**
     * @param IdRequest[] $veterinaryEstablishmentServiceSubscriptions
     */
    public function setVeterinaryEstablishmentServiceSubscriptions(array $veterinaryEstablishmentServiceSubscriptions): self
    {
        $this->initialized['veterinaryEstablishmentServiceSubscriptions'] = true;
        $this->veterinaryEstablishmentServiceSubscriptions = $veterinaryEstablishmentServiceSubscriptions;

        return $this;
    }
}
