<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ContractDocumentResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $contract;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $pdfDocument;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $signedPdfDocument;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $signer;

    /**
     * @var string
     */
    protected $status;

    /**
     * @var \DateTime|null
     */
    protected $validatedDate;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getContract(): IdResponse
    {
        return $this->contract;
    }

    /**
     * Id - Response Model.
     */
    public function setContract(IdResponse $contract): self
    {
        $this->initialized['contract'] = true;
        $this->contract = $contract;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getPdfDocument(): IdResponse
    {
        return $this->pdfDocument;
    }

    /**
     * Id - Response Model.
     */
    public function setPdfDocument(IdResponse $pdfDocument): self
    {
        $this->initialized['pdfDocument'] = true;
        $this->pdfDocument = $pdfDocument;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getSignedPdfDocument(): IdResponse
    {
        return $this->signedPdfDocument;
    }

    /**
     * Id - Response Model.
     */
    public function setSignedPdfDocument(IdResponse $signedPdfDocument): self
    {
        $this->initialized['signedPdfDocument'] = true;
        $this->signedPdfDocument = $signedPdfDocument;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getSigner(): IdResponse
    {
        return $this->signer;
    }

    /**
     * Id - Response Model.
     */
    public function setSigner(IdResponse $signer): self
    {
        $this->initialized['signer'] = true;
        $this->signer = $signer;

        return $this;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->initialized['status'] = true;
        $this->status = $status;

        return $this;
    }

    public function getValidatedDate(): ?\DateTime
    {
        return $this->validatedDate;
    }

    public function setValidatedDate(?\DateTime $validatedDate): self
    {
        $this->initialized['validatedDate'] = true;
        $this->validatedDate = $validatedDate;

        return $this;
    }
}
