<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetPrincipalCollection extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * Retrieves the collection of Principal resources.
     *
     * @param array $queryParameters {
     *
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $email
     * @var string $type
     * @var array  $type[]
     * @var string $status
     * @var array  $status[]
     * @var string $id
     * @var string $id[]
     * @var string $order[id]
     * @var string $order[email]
     * @var string $order[created]
     * @var string $order[updated]
     * @var string $search
     *             }
     */
    public function __construct(array $queryParameters = [])
    {
        $this->queryParameters = $queryParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/api/principals';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'itemsPerPage', 'email', 'type', 'status', 'id', 'order[id]', 'order[email]', 'order[created]', 'order[updated]', 'search']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults(['page' => 1, 'itemsPerPage' => 30]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('itemsPerPage', ['int']);
        $optionsResolver->addAllowedTypes('email', ['string']);
        $optionsResolver->addAllowedTypes('type', ['string']);
        $optionsResolver->addAllowedTypes('type', ['array']);
        $optionsResolver->addAllowedTypes('status', ['string']);
        $optionsResolver->addAllowedTypes('status', ['array']);
        $optionsResolver->addAllowedTypes('id', ['string']);
        $optionsResolver->addAllowedTypes('id', ['string']);
        $optionsResolver->addAllowedTypes('order[id]', ['string']);
        $optionsResolver->addAllowedTypes('order[email]', ['string']);
        $optionsResolver->addAllowedTypes('order[created]', ['string']);
        $optionsResolver->addAllowedTypes('order[updated]', ['string']);
        $optionsResolver->addAllowedTypes('search', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet[]
     *
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\PrincipalGet[]', 'json');
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
