<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetAllVeterinaryEstablishmentServiceSubscription extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * List VeterinaryEstablishmentServiceSubscriptions.
     * A VeterinaryEstablishmentServiceSubscription represents a subscription, a contract with a fixed duration for an
     * establishment to a set of service options.
     *
     * @param array $queryParameters {
     *
     * @var int   $page the page of items to collect a part of result set
     * @var int   $limit the maximum number of items to collect a part of result set
     * @var array $id[] Filter by id
     * @var array $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array $fromCreatedDate[] Returns results whose `createdDate` is greater than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |----------Filtered---------|----------Returned----------|
     * @var array $fromUpdatedDate[] Returns results whose `updatedDate` is greater than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |----------Filtered---------|----------Returned----------|
     * @var array $fromStartDate[] Returns results whose `startDate` is greater than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |----------Filtered---------|----------Returned----------|
     * @var array $fromEndDate[] Returns results whose `endDate` is greater than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |----------Filtered---------|----------Returned----------|
     * @var array $toCreatedDate[] Returns results whose `createdDate` is lower than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |-----------Returned--------|---------Filtered-----------|
     * @var array $toUpdatedDate[] Returns results whose `updatedDate` is lower than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |-----------Returned--------|---------Filtered-----------|
     * @var array $toStartDate[] Returns results whose `startDate` is lower than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |-----------Returned--------|---------Filtered-----------|
     * @var array $toEndDate[] Returns results whose `endDate` is lower than or equal to the specified value.
     *            Example for 2022-03-15 value :
     *
     * |----Jan---|----Feb---|----Mar---|----Apr----|----May----|
     * |-----------Returned--------|---------Filtered-----------|
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortVeterinaryServiceOptionEntitled Sort by veterinaryServiceOptionEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/v1/veterinary_establishment_service_subscriptions';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'veterinaryEstablishmentId', 'veterinaryServiceOptionId', 'fromCreatedDate', 'fromUpdatedDate', 'fromStartDate', 'fromEndDate', 'toCreatedDate', 'toUpdatedDate', 'toStartDate', 'toEndDate', 'sortCreatedDate', 'sortUpdatedDate', 'sortVeterinaryServiceOptionEntitled']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryServiceOptionId', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('fromStartDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('fromEndDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toStartDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toEndDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortVeterinaryServiceOptionEntitled', ['string']);

        return $optionsResolver;
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionResponseItem[]
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionResponseItem[]', 'json');
        }
        if ((null === $contentType) === false && (206 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceSubscriptionResponseItem[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentServiceSubscriptionBadRequestException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
