<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\Validation;

class DateValidator implements DateValidatorInterface
{
    public function validate(string $date, string $format = \DateTimeInterface::ATOM): bool
    {
        $dateTime = \DateTimeImmutable::createFromFormat($format, $date);

        if ($dateTime) {
            return $dateTime->format($format) === $date;
        }

        return false;
    }
}
