<?php

declare(strict_types=1);

namespace NoahVet\Reef\Domain\BusinessRule;

interface PrivilegedCodeBusinessRuleInterface extends BusinessRuleInterface
{
    public const BLACKLIST = [
        'ABC',
        'GAZ',
        'GPT',
        'I',
        'NTP',
        'O',
        'SEC',
        'SEX',
        'U',
        'WTF',
    ];

    public function shouldNotContainABlacklistedWord(
        string $privilegedCode,
    ): bool;

    public function shouldNotContainTheSameLetterTwiceConsecutively(
        string $privilegedCode,
    ): bool;
}
