<?php

declare(strict_types=1);

namespace NoahVet\Reef\Controller\Common;

use NoahVet\Reef\Controller\AbstractController;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\Common\One\Update\AbstractUpdateMapperInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

abstract class AbstractUpdateController extends AbstractController
{
    protected function deserializeRequest(
        AbstractUpdateMapperInterface $mapper,
        string $requestDtoFqcn,
        EntityInterface $existingEntity,
    ): EntityInterface {
        return $mapper->mapRequestDtoToEntity(
            $mapper->mapDataToRequestDto(
                $this->request->getContent(),
                $requestDtoFqcn,
                $existingEntity,
            ),
        );
    }

    /**
     * @param array<string, mixed> $data
     */
    protected function getResponse(array $data): Response
    {
        return new JsonResponse(
            $data,
            Response::HTTP_OK,
        );
    }

    /**
     * @return array<string, mixed>
     */
    protected function serializeResponse(
        AbstractUpdateMapperInterface $mapper,
        EntityInterface $entity,
        string $responseDtoFqcn,
    ): array {
        return $mapper->normalizeResponseDto(
            $mapper->mapEntityToResponseDto(
                $entity,
                $responseDtoFqcn,
            ),
        );
    }
}
