<?php

declare(strict_types=1);

namespace NoahVet\Reef\Controller\Common;

use NoahVet\Reef\Controller\AbstractController;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\Common\One\Get\AbstractGetMapperInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

abstract class AbstractGetController extends AbstractController
{
    /**
     * @param array<string, mixed> $data
     */
    protected function getResponse(array $data): Response
    {
        return new JsonResponse($data);
    }

    /**
     * @return array<string, mixed>
     */
    protected function serializeResponse(
        AbstractGetMapperInterface $mapper,
        EntityInterface $entity,
        string $responseDtoFqcn,
    ): array {
        return $mapper->normalizeResponseDto(
            $mapper->mapEntityToResponseDto(
                $entity,
                $responseDtoFqcn,
            ),
        );
    }
}
