<?php

declare(strict_types=1);

namespace NoahVet\Reef\Controller\Common;

use NoahVet\Reef\Controller\AbstractController;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Factory\RequestContext\RequestContextFactoryInterface;
use NoahVet\Reef\Mapper\Common\Many\AbstractGetAllMapperInterface;
use NoahVet\Reef\Paginator\HttpPaginatorInterface;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\Response;

abstract class AbstractExportXlsxController extends AbstractController
{
    public function __construct(
        protected readonly HttpPaginatorInterface $httpPaginator,
        protected readonly RequestContextFactoryInterface $requestContextFactory,
    ) {
    }

    protected function getResponse(string $filePath): BinaryFileResponse
    {
        return new BinaryFileResponse(
            $filePath,
            0 < $this->httpPaginator->getInformation()['last'] ? Response::HTTP_PARTIAL_CONTENT : Response::HTTP_OK,
            $this->httpPaginator->getContentRangeHeader('resources'),
        );
    }

    /**
     * @param class-string<EntityInterface> $entityFqcn
     * @param class-string<object>          $responseDtoFqcn
     *
     * @return array<int, mixed>
     */
    protected function serializeResponse(
        AbstractGetAllMapperInterface $mapper,
        string $entityFqcn,
        string $responseDtoFqcn,
        bool $isPaginated = true,
    ): array {
        return $mapper->normalizeResponseDto(
            $mapper->mapDataToResponseDto(
                $this->httpPaginator->getResult(
                    $this->request,
                    $entityFqcn,
                    $this->requestContextFactory->createContextFromRequest(
                        $this->request,
                        $this->whitelist,
                    ),
                    $isPaginated,
                ),
                $responseDtoFqcn,
            ),
        );
    }
}
