<?php

declare(strict_types=1);

namespace NoahVet\Reef\Controller\Common;

use NoahVet\Reef\Controller\AbstractController;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\Common\One\Create\AbstractCreateMapperInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

abstract class AbstractCreateController extends AbstractController
{
    protected function deserializeRequest(
        AbstractCreateMapperInterface $mapper,
        string $requestDtoFqcn,
    ): EntityInterface {
        return $mapper->mapRequestDtoToEntity(
            $mapper->mapDataToRequestDto(
                $this->request->getContent(),
                $requestDtoFqcn,
            ),
        );
    }

    /**
     * @param array<string, mixed> $data
     */
    protected function getResponse(array $data): Response
    {
        return new JsonResponse(
            $data,
            Response::HTTP_CREATED,
        );
    }

    /**
     * @return array<string, mixed>
     */
    protected function serializeResponse(
        AbstractCreateMapperInterface $mapper,
        EntityInterface $entity,
        string $responseDtoFqcn,
    ): array {
        return $mapper->normalizeResponseDto(
            $mapper->mapEntityToResponseDto(
                $entity,
                $responseDtoFqcn,
            ),
        );
    }
}
