<?php

declare(strict_types=1);

namespace NoahVet\Reef\Command;

use NoahVet\Reef\Domain\Tool\FileTool;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Yaml\Yaml;

/**
 * E.g.
 *
 * bin/console reef:open-api:nelmio:dump
 */
#[AsCommand(
    name: 'reef:open-api:nelmio:dump',
    description: 'Dump nelmio api doc.',
    hidden: false,
)]
class OpenApiNelmioDumpCommand extends Command
{
    public function __construct(
        private readonly string $sourceFilePath,
        private readonly string $destinationFilePath,
    ) {
        parent::__construct('reef:open-api:nelmio:dump');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $openApiFile = Yaml::parseFile($this->sourceFilePath);
        unset($openApiFile['openapi']);

        FileTool::forceFilePutContents(
            $this->destinationFilePath,
            Yaml::dump(
                [
                    'nelmio_api_doc' => [
                        'documentation' => $openApiFile,
                    ],
                ],
                5,
            ),
        );

        return Command::SUCCESS;
    }
}
