<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model\Factory;

use NoahVet\Reef\Business\Model\TeamMember;
use NoahVet\Reef\Jane\Model\ManufacturerUserResponseItem;
use NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItem;
use NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseItem;

class TeamMemberFactory
{
    public function create(
        VeterinaryEstablishmentUserResponseItem
        |VeterinaryGroupUserResponseItem
        |ManufacturerUserResponseItem $teamMember,
    ): TeamMember {
        $userId = $teamMember->getUser()?->getId();

        if (null === $userId) {
            throw new \LogicException();
        }

        $entryDate = $teamMember->getEntryDate();
        $exitDate = $teamMember->getExitDate();

        return new TeamMember(
            $userId,
            $teamMember->getJobTitle(),
            $entryDate ? \DateTimeImmutable::createFromMutable($entryDate) : null,
            $exitDate ? \DateTimeImmutable::createFromMutable($exitDate) : null,
        );
    }
}
