<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\B_Functional\B_Cli\Command;

use NoahVet\Reef\Command\OpenApiNelmioDumpCommand;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\NullOutput;
use Symfony\Component\Yaml\Yaml;

class NelmioOAS3DumpCommandTest extends KernelTestCase
{
    private string $fixturesPrefix = './tests/B_Functional/B_Cli/Command/fixtures';

    private OpenApiNelmioDumpCommand $subject;

    protected function setUp(): void
    {
        parent::setUp();

        $this->subject = new OpenApiNelmioDumpCommand(
            $this->fixturesPrefix.'/example-open-api-file.yaml',
            $this->fixturesPrefix.'/nelmio_api_doc.yaml',
        );
    }

    public function testRunCommand(): void
    {
        // Execution of commands must be idempotent
        $i = 0;
        while (2 > $i) {
            self::assertSame(
                0,
                $this->subject->run(
                    new ArrayInput([]),
                    new NullOutput(),
                ),
            );
            self::assertEquals(
                Yaml::parse(\file_get_contents($this->fixturesPrefix.'/nelmio_api_doc.yaml')),
                Yaml::parse(\file_get_contents($this->fixturesPrefix.'/expected_nelmio_api_doc.yaml')),
            );
            \unlink($this->fixturesPrefix.'/nelmio_api_doc.yaml');
            ++$i;
        }
    }
}
