<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Symfony;

use NoahVet\Reef\Security\IAM\Finder\ResourceFinderInterface;
use NoahVet\Reef\Security\IAM\Generator\InternalGeneratorInterface;
use NoahVet\Reef\Security\IAM\Mapper\InternalResourceMapperInterface;
use NoahVet\Reef\Security\Policy\PolicyInterface;
use NoahVet\Reef\Security\User\Provider\ReefOAuthUserProviderInterface;
use NoahVet\Reef\Symfony\ReefApiClientBundle;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ChildDefinition;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class ReefApiClientBundleTest extends TestCase
{
    public function testConstruction(): void
    {
        $bundle = new ReefApiClientBundle();

        /** @var ContainerBuilder|\PHPUnit\Framework\MockObject\MockObject $containerBuilder */
        $containerBuilder = $this->getMockBuilder(ContainerBuilder::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;
        $containerBuilder
            ->expects($this->exactly(5))
            ->method('registerForAutoconfiguration')
            ->withConsecutive(
                [InternalResourceMapperInterface::class],
                [InternalGeneratorInterface::class],
                [PolicyInterface::class],
                [ResourceFinderInterface::class],
                [ReefOAuthUserProviderInterface::class],
            )
            ->willReturn(new ChildDefinition(''))
        ;

        $bundle->build($containerBuilder);
        self::assertTrue(true);
    }
}
