<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Security\IAM\Finder;

use NoahVet\Reef\Security\IAM\Finder\ResourceFinderEnumeratorInterface;
use NoahVet\Reef\Security\IAM\Finder\ResourceIterator;
use PHPUnit\Framework\TestCase;

class ResourceIteratorTest extends TestCase
{
    public function testIterate(): void
    {
        $enumerator = \Mockery::mock(ResourceFinderEnumeratorInterface::class)
            ->shouldReceive('enumerate')
            ->withNoArgs()
            ->andYield('a')
            ->getMock()
        ;

        $enumerator2 = \Mockery::mock(ResourceFinderEnumeratorInterface::class)
            ->shouldReceive('enumerate')
            ->withNoArgs()
            ->andYield('b')
            ->getMock()
        ;

        $resourceIterator = new ResourceIterator([$enumerator, $enumerator2]);

        self::assertEquals(['a', 'b'], \iterator_to_array($resourceIterator->iterate()));
    }
}
