<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Security\Authentication;

use NoahVet\Reef\Security\Authentication\BearerClientHMacComputer;
use PHPUnit\Framework\TestCase;

class BearerClientHMacComputerTest extends TestCase
{
    public function testComputeClientHMacHeader(): void
    {
        $computer = new BearerClientHMacComputer(
            'o8k80s8gzowtwcw8gkg84os0ko80ccw0w8cwk7ktaxgo8og8k',
            '44kkk8kc0ectkockc80k4o9q2z5g5sogsoc0wokk40g44so8g',
        );

        $headers = $computer->computeClientHMacHeader('NDAyMzc2YTQ0ODljYzhjNjJlYTc0ZjFhZjlhMmQ2NzkxYTJiNDgxMDQ3OWZkMjJlZDY5Yjc5NmM5NTZlMTcxOA');

        self::assertEquals(
            [
                'X-Reef-Client-ID' => 'o8k80s8gzowtwcw8gkg84os0ko80ccw0w8cwk7ktaxgo8og8k',
                'X-Reef-Client-HMAC' => 'd730282c50397b0848814da937fc5509fe5887e64b33d0aa39f89774491cbf2e',
            ],
            $headers,
        );
    }
}
