<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Repository;

use Doctrine\Persistence\ManagerRegistry;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Repository\AbstractBaseRepository;
use NoahVet\Reef\Traits\Entity\Required\IdTrait;
use PHPUnit\Framework\TestCase;
use Symfony\Component\Uid\Uuid;

final class AbstractBaseRepositoryTest extends TestCase
{
    private AbstractBaseRepository $subject;

    protected function setUp(): void
    {
        parent::setUp();
        $mock = $this->createMock(ManagerRegistry::class);
        $this->subject = new class extends AbstractBaseRepository {
            public function __construct()
            {
                $registry = new class implements ManagerRegistry {
                    public function getDefaultConnectionName(): void
                    {
                    }

                    public function getConnection(?string $name = null): void
                    {
                    }

                    public function getConnections(): void
                    {
                    }

                    public function getConnectionNames(): void
                    {
                    }

                    public function getDefaultManagerName(): void
                    {
                    }

                    public function getManager(?string $name = null): void
                    {
                    }

                    public function getManagers(): void
                    {
                    }

                    public function resetManager(?string $name = null): void
                    {
                    }

                    public function getManagerNames(): void
                    {
                    }

                    public function getRepository(string $persistentObject, ?string $persistentManagerName = null): void
                    {
                    }

                    public function getManagerForClass(string $class): void
                    {
                    }
                };
                $entity = new class implements EntityInterface {
                    use IdTrait;
                };
                parent::__construct(
                    $registry,
                    $entity::class,
                );
            }
        };
    }

    public function testConvertUuidFilterValuesReturnsOriginalValuesWhenFilterIsNotId(): void
    {
        $this->assertSame(
            ['foo', 123, false],
            $this->subject->convertUuidFilterValues(
                'name',
                ['foo', 123, false],
            ),
        );
    }

    /**
     * @dataProvider idFilterKeysProvider
     */
    public function testConvertUuidFilterValuesConvertsValidUuidStrings(string $filterKey): void
    {
        $validUuid = '1f0a296c-38c2-6d70-8f34-91024dd16617';
        $binaryUuid = Uuid::fromRfc4122($validUuid)->toBinary();

        $values = [$validUuid, 'not-an-uuid', 42];

        $result = $this->subject->convertUuidFilterValues($filterKey, $values);

        $this->assertSame([$binaryUuid, 'not-an-uuid', 42], $result);
    }

    /**
     * @return iterable<array<int, string>>
     */
    public function idFilterKeysProvider(): iterable
    {
        yield ['ownerId'];
        yield ['ownerIds'];
    }
}
