<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Plugin\Cache\Model;

use NoahVet\Reef\Plugin\Cache\Model\CacheableResponse;
use Nyholm\Psr7\Stream;
use PHPUnit\Framework\TestCase;

class CacheableResponseTest extends TestCase
{
    public function testSerializeAndUnserialize(): void
    {
        $originalData = [
            'protocol' => '1.1',
            'statusCode' => 200,
            'reasonPhrase' => 'OK',
            'headers' => [
                'content-type' => ['application/json'],
                'cache-control' => ['no-cache'],
            ],
            'body' => '{"message": "success"}',
        ];

        // Create original response
        $originalResponse = new CacheableResponse(
            $originalData['protocol'],
            $originalData['statusCode'],
            $originalData['reasonPhrase'],
            $originalData['headers'],
            Stream::create($originalData['body']),
        );

        // Serialize the response
        $serialized = \serialize($originalResponse);

        // Unserialize the response
        $unserializedResponse = \unserialize($serialized);

        // Assertions to verify unserialized data matches original
        $this->assertSame($originalData['protocol'], $unserializedResponse->getProtocolVersion());
        $this->assertSame($originalData['statusCode'], $unserializedResponse->getStatusCode());
        $this->assertSame($originalData['reasonPhrase'], $unserializedResponse->getReasonPhrase());
        $this->assertSame($originalData['headers'], $unserializedResponse->getHeaders());
        $this->assertSame($originalData['body'], $unserializedResponse->getBody()->getContents());
    }
}
