<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Phpunit\Fixture;

use NoahVet\Reef\Phpunit\Fixture\PermissionFixture;
use NoahVet\Reef\Security\IAM\Model\Resource;
use PHPUnit\Framework\TestCase;

class PermissionFixtureTest extends TestCase
{
    public function testGetTarget(): void
    {
        $resource = Resource::fromString('reef:phpunit:ResourceType', 'id');

        $fixture = new PermissionFixture(
            $resource,
            [],
        );

        self::assertSame($resource, $fixture->getTarget());
    }

    public function testGetResourceType(): void
    {
        $resource = Resource::fromString('reef:phpunit:ResourceType', 'id');

        $fixture = new PermissionFixture(
            $resource,
            [],
        );

        self::assertSame($resource->getResourceType(), $fixture->getResourceType());
    }

    public function testGetTargetSlug(): void
    {
        $resource = Resource::fromString('reef:phpunit:ResourceType', 'id');

        $fixture = new PermissionFixture(
            $resource,
            [],
        );

        self::assertSame($resource->getSlug(), $fixture->getTargetSlug());
    }

    public function testGetAllowedPermission(): void
    {
        $resource = Resource::fromString('reef:phpunit:ResourceType', 'id');

        $fixture = new PermissionFixture(
            $resource,
            ['perm_read', 'perm_write'],
        );

        self::assertEquals(['perm_read', 'perm_write'], $fixture->getAllowedPermission());
    }
}
