<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Validation\V2;

use NoahVet\Reef\Domain\Validation\V2\OpenApiPropertyValidator;
use NoahVet\Reef\Domain\Validation\V2\OpenApiValidator;
use NoahVet\Reef\Domain\Validation\V2\OpenApiValidatorInterface;
use PHPUnit\Framework\TestCase;

/**
 * This class respects the pattern:
 * testGiven<Context>When<Method>Then<ExpectedResult>
 */
final class EmptyOpenApiValidatorTest extends TestCase
{
    private OpenApiValidatorInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new OpenApiValidator([
            new OpenApiPropertyValidator(),
        ]);
    }

    /**
     * Given an empty model and an empty payload,
     * When validate call,
     * Then the validation returns true.
     */
    public function testGivenEmptyModelAndEmptyPayloadWhenValidateCallThenReturnsTrue(): void
    {
        $rules = [];
        $payload = [];

        $this->assertTrue($this->subject->validate($payload, $rules));
    }
}
