<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Process;

use NoahVet\Reef\Domain\Process\SymfonyProcess;
use PHPUnit\Framework\TestCase;

class SymfonyProcessTest extends TestCase
{
    public function testGetPhpBinaryPathReturnsPhpBinaryConstant(): void
    {
        $phpBinary = SymfonyProcess::getPhpBinaryPath();
        $this->assertEquals(\PHP_BINARY, $phpBinary);
    }

    public function testGetSymfonyConsolePathDefaultsToBinConsole(): void
    {
        unset($_SERVER['PHP_SELF']);
        $consolePath = SymfonyProcess::getSymfonyConsolePath();
        $this->assertEquals('bin/console', $consolePath);
    }

    public function testGetSymfonyConsolePathInvalidPathReturnsBinConsole(): void
    {
        $_SERVER['PHP_SELF'] = '/var/www/invalid/path/console';
        $consolePath = SymfonyProcess::getSymfonyConsolePath();
        $this->assertEquals('bin/console', $consolePath);
    }
}
