<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Controller;

use NoahVet\Reef\Controller\AbstractController;
use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class AbstractControllerTest extends TestCase
{
    private AbstractController $subject;

    private Request $request;

    protected function setUp(): void
    {
        parent::setUp();
        $this->subject = new class extends AbstractController {
            private array $mockedParseQueryParamFile = [];

            public function getWhitelist(): array
            {
                return $this->whitelist;
            }

            public function mapQueryParamToWhitelist(): void
            {
                parent::mapQueryParamToWhitelist();
            }

            public function getNoContentResponse(): Response
            {
                return parent::getNoContentResponse();
            }

            public function mockParseQueryParamFile(array $data): void
            {
                $this->mockedParseQueryParamFile = $data;
            }

            public function parseQueryParamFile(string $uri): array
            {
                return $this->mockedParseQueryParamFile;
            }
        };

        $this->request = $this->createMock(Request::class);
        $this->subject->setRequest($this->request);
    }

    public function testGetNoContentResponse(): void
    {
        $response = $this->subject->getNoContentResponse();

        $this->assertInstanceOf(JsonResponse::class, $response);
        $this->assertSame(Response::HTTP_NO_CONTENT, $response->getStatusCode());
    }

    public function testMapQueryParamToWhitelist(): void
    {
        $this->request->expects($this->once())
            ->method('getRequestUri')
            ->willReturn('/api/resource?param=value')
        ;

        $mockData = ['page', 'limit', 'sortName', 'filterCategory'];
        $this->subject->mockParseQueryParamFile($mockData);

        $this->subject->mapQueryParamToWhitelist();

        $expectedWhitelist = [
            'filters' => ['filterCategory'],
            'pagination' => ['page' => 0, 'limit' => 1],
            'permissions' => [],
            'sorting' => ['sortName'],
        ];

        $this->assertSame($expectedWhitelist, $this->subject->getWhitelist());
    }
}
