<?php

declare(strict_types=1);

namespace NoahVet\Reef\Traits\Entity\Required;

use Doctrine\ORM\Mapping as ORM;

trait TranslationTrait
{
    /**
     * e.g.
     * {
     *    "en_GB": {
     *      "entitled": "Welcome !"
     *    },
     *   "fr_FR": {
     *     "entitled": "Bienvenue !"
     *   }
     * }.
     *
     * @var array<string, mixed>
     */
    #[ORM\Column(type: 'json')]
    private array $translations = [];

    /**
     * @return array<string, mixed>
     */
    public function getTranslations(): array
    {
        return $this->translations;
    }

    /**
     * @param array<string, mixed> $translations
     */
    public function setTranslations(array $translations): self
    {
        $this->translations = $translations;

        return $this;
    }

    public function setTranslation(string $locale, string $key, string $value): self
    {
        $this->translations[$locale][$key] = $value;

        return $this;
    }
}
