<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Mapper;

use NoahVet\Reef\Security\IAM\Model\Resource;

/**
 * Allow mapping of an internal object to a resource (used in voter).
 */
class IAMResourceMapper
{
    /**
     * @var iterable<InternalResourceMapperInterface>
     */
    protected iterable $mappers;

    /**
     * @param iterable<InternalResourceMapperInterface> $mappers
     */
    public function __construct(
        iterable $mappers,
    ) {
        $this->mappers = $mappers;
    }

    public function map(mixed $subject): ?Resource
    {
        foreach ($this->mappers as $mapper) {
            if ($mapper->canMap($subject)) {
                return $mapper->mapResource($subject);
            }
        }

        return null;
    }
}
