<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\Authentication;

class BearerClientHMacComputer
{
    protected string $reefClientId;

    protected string $reefClientSecret;

    public function __construct(
        string $reefClientId,
        string $reefClientSecret,
    ) {
        $this->reefClientId = $reefClientId;
        $this->reefClientSecret = $reefClientSecret;
    }

    /**
     * @return array{"X-Reef-Client-ID": string, "X-Reef-Client-HMAC": string}
     */
    public function computeClientHMacHeader(string $bearer): array
    {
        $clientHmac = \hash_hmac('sha256', $bearer, $this->reefClientSecret);

        return [
            'X-Reef-Client-ID' => $this->reefClientId,
            'X-Reef-Client-HMAC' => $clientHmac,
        ];
    }
}
