<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Notification\Sender;

use NoahVet\Reef\RabbitMQ\Notification\Factory\ReefNotificationFactoryInterface;
use NoahVet\Reef\RabbitMQ\Producer\Factory\ReefMQProducerFactoryInterface;
use NoahVet\Reef\Security\IAM\Model\Resource;

class ReefNotificationSender implements ReefNotificationSenderInterface
{
    public function __construct(
        private readonly ReefNotificationFactoryInterface $reefNotificationFactory,
        private readonly ReefMQProducerFactoryInterface $producerFactory,
    ) {
    }

    public function sendNotification(
        Resource $resource,
        string $action,
        array $rawData,
    ): void {
        $this->producerFactory->getProducer()
            ->publishNotification(
                $this->reefNotificationFactory->createNotification($resource, $action, $rawData),
            )
        ;
    }
}
