<?php

declare(strict_types=1);

namespace NoahVet\Reef\Plugin\Cache;

use Http\Promise\Promise;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

interface HttpResponseCacheInterface
{
    public function cacheResponse(RequestInterface $request, ResponseInterface $response): ResponseInterface;

    public function cacheResponsePromise(RequestInterface $request, Promise $responsePromise): Promise;

    public function getCachedResponse(RequestInterface $request): ?ResponseInterface;
}
