<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\One;

/**
 * @template EntityType of object
 */
interface AbstractOneMapperInterface
{
    /**
     * @template ResponseDtoType of object
     *
     * @param EntityType                    $entity
     * @param class-string<ResponseDtoType> $responseDtoFqcn
     *
     * @return ResponseDtoType
     */
    public function mapEntityToResponseDto(
        object $entity,
        string $responseDtoFqcn,
    ): object;

    /**
     * @return array<string, mixed>
     */
    public function normalizeResponseDto(
        object $responseDto,
    ): array;
}
