<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryGroupResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\VeterinaryGroupResponse::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\VeterinaryGroupResponse::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryGroupResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('banner', $data) && null !== $data['banner']) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context));
            unset($data['banner']);
        } elseif (\array_key_exists('banner', $data) && null === $data['banner']) {
            $object->setBanner(null);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('generalConditionUrl', $data) && null !== $data['generalConditionUrl']) {
            $object->setGeneralConditionUrl($data['generalConditionUrl']);
            unset($data['generalConditionUrl']);
        } elseif (\array_key_exists('generalConditionUrl', $data) && null === $data['generalConditionUrl']) {
            $object->setGeneralConditionUrl(null);
        }
        if (\array_key_exists('groupCode', $data) && null !== $data['groupCode']) {
            $object->setGroupCode($data['groupCode']);
            unset($data['groupCode']);
        } elseif (\array_key_exists('groupCode', $data) && null === $data['groupCode']) {
            $object->setGroupCode(null);
        }
        if (\array_key_exists('legalNoticeUrl', $data) && null !== $data['legalNoticeUrl']) {
            $object->setLegalNoticeUrl($data['legalNoticeUrl']);
            unset($data['legalNoticeUrl']);
        } elseif (\array_key_exists('legalNoticeUrl', $data) && null === $data['legalNoticeUrl']) {
            $object->setLegalNoticeUrl(null);
        }
        if (\array_key_exists('legalStructure', $data) && null !== $data['legalStructure']) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context));
            unset($data['legalStructure']);
        } elseif (\array_key_exists('legalStructure', $data) && null === $data['legalStructure']) {
            $object->setLegalStructure(null);
        }
        if (\array_key_exists('logo', $data) && null !== $data['logo']) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context));
            unset($data['logo']);
        } elseif (\array_key_exists('logo', $data) && null === $data['logo']) {
            $object->setLogo(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && null !== $data['mainBillingAccount']) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context));
            unset($data['mainBillingAccount']);
        } elseif (\array_key_exists('mainBillingAccount', $data) && null === $data['mainBillingAccount']) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('personalisedMention', $data) && null !== $data['personalisedMention']) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        } elseif (\array_key_exists('personalisedMention', $data) && null === $data['personalisedMention']) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('pictures', $data)) {
            $values = [];
            foreach ($data['pictures'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context);
            }
            $object->setPictures($values);
            unset($data['pictures']);
        }
        if (\array_key_exists('postalAddresses', $data) && null !== $data['postalAddresses']) {
            $values_1 = [];
            foreach ($data['postalAddresses'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, \NoahVet\Reef\Jane\Model\NullableIdResponse::class, 'json', $context);
            }
            $object->setPostalAddresses($values_1);
            unset($data['postalAddresses']);
        } elseif (\array_key_exists('postalAddresses', $data) && null === $data['postalAddresses']) {
            $object->setPostalAddresses(null);
        }
        if (\array_key_exists('privacyPolicyUrl', $data) && null !== $data['privacyPolicyUrl']) {
            $object->setPrivacyPolicyUrl($data['privacyPolicyUrl']);
            unset($data['privacyPolicyUrl']);
        } elseif (\array_key_exists('privacyPolicyUrl', $data) && null === $data['privacyPolicyUrl']) {
            $object->setPrivacyPolicyUrl(null);
        }
        if (\array_key_exists('serviceVatCategory', $data)) {
            $object->setServiceVatCategory($data['serviceVatCategory']);
            unset($data['serviceVatCategory']);
        }
        if (\array_key_exists('shortDescription', $data)) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        }
        if (\array_key_exists('status', $data)) {
            $object->setStatus($data['status']);
            unset($data['status']);
        }
        foreach ($data as $key => $value_2) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_2;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['id'] = $data->getId();
        $dataArray['createdDate'] = $data->getCreatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['updatedDate'] = $data->getUpdatedDate()?->format('Y-m-d\\TH:i:sP');
        $dataArray['banner'] = $this->normalizer->normalize($data->getBanner(), 'json', $context);
        $dataArray['entitled'] = $data->getEntitled();
        $dataArray['generalConditionUrl'] = $data->getGeneralConditionUrl();
        $dataArray['groupCode'] = $data->getGroupCode();
        $dataArray['legalNoticeUrl'] = $data->getLegalNoticeUrl();
        $dataArray['legalStructure'] = $this->normalizer->normalize($data->getLegalStructure(), 'json', $context);
        $dataArray['logo'] = $this->normalizer->normalize($data->getLogo(), 'json', $context);
        $dataArray['longDescription'] = $data->getLongDescription();
        $dataArray['mainBillingAccount'] = $this->normalizer->normalize($data->getMainBillingAccount(), 'json', $context);
        if ($data->isInitialized('personalisedMention') && null !== $data->getPersonalisedMention()) {
            $dataArray['personalisedMention'] = $data->getPersonalisedMention();
        }
        $values = [];
        foreach ($data->getPictures() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['pictures'] = $values;
        $values_1 = [];
        foreach ($data->getPostalAddresses() as $value_1) {
            $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
        }
        $dataArray['postalAddresses'] = $values_1;
        $dataArray['privacyPolicyUrl'] = $data->getPrivacyPolicyUrl();
        $dataArray['serviceVatCategory'] = $data->getServiceVatCategory();
        $dataArray['shortDescription'] = $data->getShortDescription();
        $dataArray['status'] = $data->getStatus();
        foreach ($data as $key => $value_2) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_2;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\VeterinaryGroupResponse::class => false];
    }
}
