<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class V1PetsIdPatchBodyNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\V1PetsIdPatchBody::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\V1PetsIdPatchBody::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\V1PetsIdPatchBody();
        if (\array_key_exists('isAnonymous', $data) && \is_int($data['isAnonymous'])) {
            $data['isAnonymous'] = (bool) $data['isAnonymous'];
        }
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('isAnonymous', $data) && null !== $data['isAnonymous']) {
            $object->setIsAnonymous($data['isAnonymous']);
            unset($data['isAnonymous']);
        } elseif (\array_key_exists('isAnonymous', $data) && null === $data['isAnonymous']) {
            $object->setIsAnonymous(null);
        }
        if (\array_key_exists('name', $data) && null !== $data['name']) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && null === $data['name']) {
            $object->setName(null);
        }
        if (\array_key_exists('passportNumber', $data) && null !== $data['passportNumber']) {
            $object->setPassportNumber($data['passportNumber']);
            unset($data['passportNumber']);
        } elseif (\array_key_exists('passportNumber', $data) && null === $data['passportNumber']) {
            $object->setPassportNumber(null);
        }
        if (\array_key_exists('tattoo', $data) && null !== $data['tattoo']) {
            $object->setTattoo($this->denormalizer->denormalize($data['tattoo'], \NoahVet\Reef\Jane\Model\V1PetsIdPatchBodyTattoo::class, 'json', $context));
            unset($data['tattoo']);
        } elseif (\array_key_exists('tattoo', $data) && null === $data['tattoo']) {
            $object->setTattoo(null);
        }
        if (\array_key_exists('specie', $data) && null !== $data['specie']) {
            $object->setSpecie($this->denormalizer->denormalize($data['specie'], \NoahVet\Reef\Jane\Model\V1PetsIdPatchBodySpecie::class, 'json', $context));
            unset($data['specie']);
        } elseif (\array_key_exists('specie', $data) && null === $data['specie']) {
            $object->setSpecie(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('isAnonymous') && null !== $data->getIsAnonymous()) {
            $dataArray['isAnonymous'] = $data->getIsAnonymous();
        }
        if ($data->isInitialized('name') && null !== $data->getName()) {
            $dataArray['name'] = $data->getName();
        }
        if ($data->isInitialized('passportNumber') && null !== $data->getPassportNumber()) {
            $dataArray['passportNumber'] = $data->getPassportNumber();
        }
        if ($data->isInitialized('tattoo') && null !== $data->getTattoo()) {
            $dataArray['tattoo'] = $this->normalizer->normalize($data->getTattoo(), 'json', $context);
        }
        if ($data->isInitialized('specie') && null !== $data->getSpecie()) {
            $dataArray['specie'] = $this->normalizer->normalize($data->getSpecie(), 'json', $context);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\V1PetsIdPatchBody::class => false];
    }
}
