<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryGroupRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('banner', $data) && null !== $data['banner']) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], \NoahVet\Reef\Jane\Model\NullableIdRequest::class, 'json', $context));
            unset($data['banner']);
        } elseif (\array_key_exists('banner', $data) && null === $data['banner']) {
            $object->setBanner(null);
        }
        if (\array_key_exists('entitled', $data) && null !== $data['entitled']) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        } elseif (\array_key_exists('entitled', $data) && null === $data['entitled']) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('generalConditionUrl', $data) && null !== $data['generalConditionUrl']) {
            $object->setGeneralConditionUrl($data['generalConditionUrl']);
            unset($data['generalConditionUrl']);
        } elseif (\array_key_exists('generalConditionUrl', $data) && null === $data['generalConditionUrl']) {
            $object->setGeneralConditionUrl(null);
        }
        if (\array_key_exists('groupCode', $data) && null !== $data['groupCode']) {
            $object->setGroupCode($data['groupCode']);
            unset($data['groupCode']);
        } elseif (\array_key_exists('groupCode', $data) && null === $data['groupCode']) {
            $object->setGroupCode(null);
        }
        if (\array_key_exists('legalNoticeUrl', $data) && null !== $data['legalNoticeUrl']) {
            $object->setLegalNoticeUrl($data['legalNoticeUrl']);
            unset($data['legalNoticeUrl']);
        } elseif (\array_key_exists('legalNoticeUrl', $data) && null === $data['legalNoticeUrl']) {
            $object->setLegalNoticeUrl(null);
        }
        if (\array_key_exists('logo', $data) && null !== $data['logo']) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], \NoahVet\Reef\Jane\Model\NullableIdRequest::class, 'json', $context));
            unset($data['logo']);
        } elseif (\array_key_exists('logo', $data) && null === $data['logo']) {
            $object->setLogo(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && null !== $data['mainBillingAccount']) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], \NoahVet\Reef\Jane\Model\NullableIdRequest::class, 'json', $context));
            unset($data['mainBillingAccount']);
        } elseif (\array_key_exists('mainBillingAccount', $data) && null === $data['mainBillingAccount']) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('personalisedMention', $data) && null !== $data['personalisedMention']) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        } elseif (\array_key_exists('personalisedMention', $data) && null === $data['personalisedMention']) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('pictures', $data) && null !== $data['pictures']) {
            $values = [];
            foreach ($data['pictures'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\IdRequest::class, 'json', $context);
            }
            $object->setPictures($values);
            unset($data['pictures']);
        } elseif (\array_key_exists('pictures', $data) && null === $data['pictures']) {
            $object->setPictures(null);
        }
        if (\array_key_exists('privacyPolicyUrl', $data) && null !== $data['privacyPolicyUrl']) {
            $object->setPrivacyPolicyUrl($data['privacyPolicyUrl']);
            unset($data['privacyPolicyUrl']);
        } elseif (\array_key_exists('privacyPolicyUrl', $data) && null === $data['privacyPolicyUrl']) {
            $object->setPrivacyPolicyUrl(null);
        }
        if (\array_key_exists('serviceVatCategory', $data) && null !== $data['serviceVatCategory']) {
            $object->setServiceVatCategory($data['serviceVatCategory']);
            unset($data['serviceVatCategory']);
        } elseif (\array_key_exists('serviceVatCategory', $data) && null === $data['serviceVatCategory']) {
            $object->setServiceVatCategory(null);
        }
        if (\array_key_exists('shortDescription', $data) && null !== $data['shortDescription']) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        } elseif (\array_key_exists('shortDescription', $data) && null === $data['shortDescription']) {
            $object->setShortDescription(null);
        }
        if (\array_key_exists('status', $data) && null !== $data['status']) {
            $object->setStatus($data['status']);
            unset($data['status']);
        } elseif (\array_key_exists('status', $data) && null === $data['status']) {
            $object->setStatus(null);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('banner') && null !== $data->getBanner()) {
            $dataArray['banner'] = $this->normalizer->normalize($data->getBanner(), 'json', $context);
        }
        if ($data->isInitialized('entitled') && null !== $data->getEntitled()) {
            $dataArray['entitled'] = $data->getEntitled();
        }
        if ($data->isInitialized('generalConditionUrl') && null !== $data->getGeneralConditionUrl()) {
            $dataArray['generalConditionUrl'] = $data->getGeneralConditionUrl();
        }
        if ($data->isInitialized('groupCode') && null !== $data->getGroupCode()) {
            $dataArray['groupCode'] = $data->getGroupCode();
        }
        if ($data->isInitialized('legalNoticeUrl') && null !== $data->getLegalNoticeUrl()) {
            $dataArray['legalNoticeUrl'] = $data->getLegalNoticeUrl();
        }
        if ($data->isInitialized('logo') && null !== $data->getLogo()) {
            $dataArray['logo'] = $this->normalizer->normalize($data->getLogo(), 'json', $context);
        }
        if ($data->isInitialized('longDescription') && null !== $data->getLongDescription()) {
            $dataArray['longDescription'] = $data->getLongDescription();
        }
        if ($data->isInitialized('mainBillingAccount') && null !== $data->getMainBillingAccount()) {
            $dataArray['mainBillingAccount'] = $this->normalizer->normalize($data->getMainBillingAccount(), 'json', $context);
        }
        if ($data->isInitialized('personalisedMention') && null !== $data->getPersonalisedMention()) {
            $dataArray['personalisedMention'] = $data->getPersonalisedMention();
        }
        if ($data->isInitialized('pictures') && null !== $data->getPictures()) {
            $values = [];
            foreach ($data->getPictures() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $dataArray['pictures'] = $values;
        }
        if ($data->isInitialized('privacyPolicyUrl') && null !== $data->getPrivacyPolicyUrl()) {
            $dataArray['privacyPolicyUrl'] = $data->getPrivacyPolicyUrl();
        }
        if ($data->isInitialized('serviceVatCategory') && null !== $data->getServiceVatCategory()) {
            $dataArray['serviceVatCategory'] = $data->getServiceVatCategory();
        }
        if ($data->isInitialized('shortDescription') && null !== $data->getShortDescription()) {
            $dataArray['shortDescription'] = $data->getShortDescription();
        }
        if ($data->isInitialized('status') && null !== $data->getStatus()) {
            $dataArray['status'] = $data->getStatus();
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupRequest::class => false];
    }
}
