<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasPostalAddressRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\SchemasPostalAddressRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\SchemasPostalAddressRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasPostalAddressRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('addressSupplement', $data) && null !== $data['addressSupplement']) {
            $object->setAddressSupplement($data['addressSupplement']);
            unset($data['addressSupplement']);
        } elseif (\array_key_exists('addressSupplement', $data) && null === $data['addressSupplement']) {
            $object->setAddressSupplement(null);
        }
        if (\array_key_exists('city', $data) && null !== $data['city']) {
            $object->setCity($data['city']);
            unset($data['city']);
        } elseif (\array_key_exists('city', $data) && null === $data['city']) {
            $object->setCity(null);
        }
        if (\array_key_exists('country', $data) && null !== $data['country']) {
            $object->setCountry($data['country']);
            unset($data['country']);
        } elseif (\array_key_exists('country', $data) && null === $data['country']) {
            $object->setCountry(null);
        }
        if (\array_key_exists('coordinates', $data) && null !== $data['coordinates']) {
            $object->setCoordinates($this->denormalizer->denormalize($data['coordinates'], \NoahVet\Reef\Jane\Model\CoordinateRequest::class, 'json', $context));
            unset($data['coordinates']);
        } elseif (\array_key_exists('coordinates', $data) && null === $data['coordinates']) {
            $object->setCoordinates(null);
        }
        if (\array_key_exists('department', $data) && null !== $data['department']) {
            $object->setDepartment($data['department']);
            unset($data['department']);
        } elseif (\array_key_exists('department', $data) && null === $data['department']) {
            $object->setDepartment(null);
        }
        if (\array_key_exists('entitled', $data) && null !== $data['entitled']) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        } elseif (\array_key_exists('entitled', $data) && null === $data['entitled']) {
            $object->setEntitled(null);
        }
        if (\array_key_exists('postBoxNumber', $data) && null !== $data['postBoxNumber']) {
            $object->setPostBoxNumber($data['postBoxNumber']);
            unset($data['postBoxNumber']);
        } elseif (\array_key_exists('postBoxNumber', $data) && null === $data['postBoxNumber']) {
            $object->setPostBoxNumber(null);
        }
        if (\array_key_exists('postalCode', $data) && null !== $data['postalCode']) {
            $object->setPostalCode($data['postalCode']);
            unset($data['postalCode']);
        } elseif (\array_key_exists('postalCode', $data) && null === $data['postalCode']) {
            $object->setPostalCode(null);
        }
        if (\array_key_exists('recipientIdentity', $data) && null !== $data['recipientIdentity']) {
            $object->setRecipientIdentity($data['recipientIdentity']);
            unset($data['recipientIdentity']);
        } elseif (\array_key_exists('recipientIdentity', $data) && null === $data['recipientIdentity']) {
            $object->setRecipientIdentity(null);
        }
        if (\array_key_exists('region', $data) && null !== $data['region']) {
            $object->setRegion($data['region']);
            unset($data['region']);
        } elseif (\array_key_exists('region', $data) && null === $data['region']) {
            $object->setRegion(null);
        }
        if (\array_key_exists('streetName', $data) && null !== $data['streetName']) {
            $object->setStreetName($data['streetName']);
            unset($data['streetName']);
        } elseif (\array_key_exists('streetName', $data) && null === $data['streetName']) {
            $object->setStreetName(null);
        }
        if (\array_key_exists('streetNumber', $data) && null !== $data['streetNumber']) {
            $object->setStreetNumber($data['streetNumber']);
            unset($data['streetNumber']);
        } elseif (\array_key_exists('streetNumber', $data) && null === $data['streetNumber']) {
            $object->setStreetNumber(null);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        if ($data->isInitialized('addressSupplement') && null !== $data->getAddressSupplement()) {
            $dataArray['addressSupplement'] = $data->getAddressSupplement();
        }
        if ($data->isInitialized('city') && null !== $data->getCity()) {
            $dataArray['city'] = $data->getCity();
        }
        if ($data->isInitialized('country') && null !== $data->getCountry()) {
            $dataArray['country'] = $data->getCountry();
        }
        if ($data->isInitialized('coordinates') && null !== $data->getCoordinates()) {
            $dataArray['coordinates'] = $this->normalizer->normalize($data->getCoordinates(), 'json', $context);
        }
        if ($data->isInitialized('department') && null !== $data->getDepartment()) {
            $dataArray['department'] = $data->getDepartment();
        }
        if ($data->isInitialized('entitled') && null !== $data->getEntitled()) {
            $dataArray['entitled'] = $data->getEntitled();
        }
        if ($data->isInitialized('postBoxNumber') && null !== $data->getPostBoxNumber()) {
            $dataArray['postBoxNumber'] = $data->getPostBoxNumber();
        }
        if ($data->isInitialized('postalCode') && null !== $data->getPostalCode()) {
            $dataArray['postalCode'] = $data->getPostalCode();
        }
        if ($data->isInitialized('recipientIdentity') && null !== $data->getRecipientIdentity()) {
            $dataArray['recipientIdentity'] = $data->getRecipientIdentity();
        }
        if ($data->isInitialized('region') && null !== $data->getRegion()) {
            $dataArray['region'] = $data->getRegion();
        }
        if ($data->isInitialized('streetName') && null !== $data->getStreetName()) {
            $dataArray['streetName'] = $data->getStreetName();
        }
        if ($data->isInitialized('streetNumber') && null !== $data->getStreetNumber()) {
            $dataArray['streetNumber'] = $data->getStreetNumber();
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\SchemasPostalAddressRequest::class => false];
    }
}
