<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class CreditNoteRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization(mixed $data, string $type, ?string $format = null, array $context = []): bool
    {
        return \NoahVet\Reef\Jane\Model\CreditNoteRequest::class === $type;
    }

    public function supportsNormalization(mixed $data, ?string $format = null, array $context = []): bool
    {
        return \is_object($data) && \NoahVet\Reef\Jane\Model\CreditNoteRequest::class === $data::class;
    }

    public function denormalize(mixed $data, string $type, ?string $format = null, array $context = []): mixed
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\CreditNoteRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('accountingCode', $data)) {
            $object->setAccountingCode($data['accountingCode']);
            unset($data['accountingCode']);
        }
        if (\array_key_exists('deliveryAddress', $data)) {
            $object->setDeliveryAddress($this->denormalizer->denormalize($data['deliveryAddress'], \NoahVet\Reef\Jane\Model\InvoiceAddressRequest::class, 'json', $context));
            unset($data['deliveryAddress']);
        }
        if (\array_key_exists('deliveryInformation', $data)) {
            $object->setDeliveryInformation($this->denormalizer->denormalize($data['deliveryInformation'], \NoahVet\Reef\Jane\Model\CreditNoteRequestDeliveryInformation::class, 'json', $context));
            unset($data['deliveryInformation']);
        }
        if (\array_key_exists('entitled', $data)) {
            $object->setEntitled($data['entitled']);
            unset($data['entitled']);
        }
        if (\array_key_exists('invoiceLines', $data)) {
            $values = [];
            foreach ($data['invoiceLines'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, \NoahVet\Reef\Jane\Model\IdRequest::class, 'json', $context);
            }
            $object->setInvoiceLines($values);
            unset($data['invoiceLines']);
        }
        if (\array_key_exists('personalisedMention', $data) && null !== $data['personalisedMention']) {
            $object->setPersonalisedMention($data['personalisedMention']);
            unset($data['personalisedMention']);
        } elseif (\array_key_exists('personalisedMention', $data) && null === $data['personalisedMention']) {
            $object->setPersonalisedMention(null);
        }
        if (\array_key_exists('receiverAddress', $data)) {
            $object->setReceiverAddress($this->denormalizer->denormalize($data['receiverAddress'], \NoahVet\Reef\Jane\Model\InvoiceAddressRequest::class, 'json', $context));
            unset($data['receiverAddress']);
        }
        if (\array_key_exists('receiverInformation', $data)) {
            $object->setReceiverInformation($this->denormalizer->denormalize($data['receiverInformation'], \NoahVet\Reef\Jane\Model\CreditNoteRequestReceiverInformation::class, 'json', $context));
            unset($data['receiverInformation']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    public function normalize(mixed $data, ?string $format = null, array $context = []): array|string|int|float|bool|\ArrayObject|null
    {
        $dataArray = [];
        $dataArray['accountingCode'] = $data->getAccountingCode();
        $dataArray['deliveryAddress'] = $this->normalizer->normalize($data->getDeliveryAddress(), 'json', $context);
        $dataArray['deliveryInformation'] = $this->normalizer->normalize($data->getDeliveryInformation(), 'json', $context);
        $dataArray['entitled'] = $data->getEntitled();
        $values = [];
        foreach ($data->getInvoiceLines() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $dataArray['invoiceLines'] = $values;
        if ($data->isInitialized('personalisedMention') && null !== $data->getPersonalisedMention()) {
            $dataArray['personalisedMention'] = $data->getPersonalisedMention();
        }
        $dataArray['receiverAddress'] = $this->normalizer->normalize($data->getReceiverAddress(), 'json', $context);
        $dataArray['receiverInformation'] = $this->normalizer->normalize($data->getReceiverInformation(), 'json', $context);
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $dataArray[$key] = $value_1;
            }
        }

        return $dataArray;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return [\NoahVet\Reef\Jane\Model\CreditNoteRequest::class => false];
    }
}
