<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class WebOrderProductResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var int
     */
    protected $mvsId;

    /**
     * @var string
     */
    protected $gtin;

    /**
     * @var string
     */
    protected $supplierCode;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $format;

    /**
     * @var string
     */
    protected $category;

    /**
     * @var string
     */
    protected $manufacturer;

    /**
     * @var int
     */
    protected $quantity;

    /**
     * @var float
     */
    protected $unitPrice;

    /**
     * @var float
     */
    protected $totalPrice;

    /**
     * @var float
     */
    protected $valuedTotalPrice;

    /**
     * @var float
     */
    protected $payRate;

    /**
     * @var float
     */
    protected $paying;

    /**
     * @var float
     */
    protected $yearEndDiscountRate;

    /**
     * @var float
     */
    protected $yearEndDiscount;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getMvsId(): int
    {
        return $this->mvsId;
    }

    public function setMvsId(int $mvsId): self
    {
        $this->initialized['mvsId'] = true;
        $this->mvsId = $mvsId;

        return $this;
    }

    public function getGtin(): string
    {
        return $this->gtin;
    }

    public function setGtin(string $gtin): self
    {
        $this->initialized['gtin'] = true;
        $this->gtin = $gtin;

        return $this;
    }

    public function getSupplierCode(): string
    {
        return $this->supplierCode;
    }

    public function setSupplierCode(string $supplierCode): self
    {
        $this->initialized['supplierCode'] = true;
        $this->supplierCode = $supplierCode;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getFormat(): string
    {
        return $this->format;
    }

    public function setFormat(string $format): self
    {
        $this->initialized['format'] = true;
        $this->format = $format;

        return $this;
    }

    public function getCategory(): string
    {
        return $this->category;
    }

    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    public function getManufacturer(): string
    {
        return $this->manufacturer;
    }

    public function setManufacturer(string $manufacturer): self
    {
        $this->initialized['manufacturer'] = true;
        $this->manufacturer = $manufacturer;

        return $this;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $quantity): self
    {
        $this->initialized['quantity'] = true;
        $this->quantity = $quantity;

        return $this;
    }

    public function getUnitPrice(): float
    {
        return $this->unitPrice;
    }

    public function setUnitPrice(float $unitPrice): self
    {
        $this->initialized['unitPrice'] = true;
        $this->unitPrice = $unitPrice;

        return $this;
    }

    public function getTotalPrice(): float
    {
        return $this->totalPrice;
    }

    public function setTotalPrice(float $totalPrice): self
    {
        $this->initialized['totalPrice'] = true;
        $this->totalPrice = $totalPrice;

        return $this;
    }

    public function getValuedTotalPrice(): float
    {
        return $this->valuedTotalPrice;
    }

    public function setValuedTotalPrice(float $valuedTotalPrice): self
    {
        $this->initialized['valuedTotalPrice'] = true;
        $this->valuedTotalPrice = $valuedTotalPrice;

        return $this;
    }

    public function getPayRate(): float
    {
        return $this->payRate;
    }

    public function setPayRate(float $payRate): self
    {
        $this->initialized['payRate'] = true;
        $this->payRate = $payRate;

        return $this;
    }

    public function getPaying(): float
    {
        return $this->paying;
    }

    public function setPaying(float $paying): self
    {
        $this->initialized['paying'] = true;
        $this->paying = $paying;

        return $this;
    }

    public function getYearEndDiscountRate(): float
    {
        return $this->yearEndDiscountRate;
    }

    public function setYearEndDiscountRate(float $yearEndDiscountRate): self
    {
        $this->initialized['yearEndDiscountRate'] = true;
        $this->yearEndDiscountRate = $yearEndDiscountRate;

        return $this;
    }

    public function getYearEndDiscount(): float
    {
        return $this->yearEndDiscount;
    }

    public function setYearEndDiscount(float $yearEndDiscount): self
    {
        $this->initialized['yearEndDiscount'] = true;
        $this->yearEndDiscount = $yearEndDiscount;

        return $this;
    }
}
