<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryGroupMandateResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $mandate;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryGroup;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getMandate(): IdResponse
    {
        return $this->mandate;
    }

    /**
     * Id - Response Model.
     */
    public function setMandate(IdResponse $mandate): self
    {
        $this->initialized['mandate'] = true;
        $this->mandate = $mandate;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryGroup(): IdResponse
    {
        return $this->veterinaryGroup;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryGroup(IdResponse $veterinaryGroup): self
    {
        $this->initialized['veterinaryGroup'] = true;
        $this->veterinaryGroup = $veterinaryGroup;

        return $this;
    }
}
