<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceDeliveryResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * The date of service delivery realisation.
     *
     * @var \DateTime|null
     */
    protected $completionDate;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * The date on which the invoice is to be generated.
     *
     * @var \DateTime|null
     */
    protected $invoiceDate;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $serviceDeliveryOption;

    /**
     * @var bool
     */
    protected $shouldGenerateInvoice;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $specificBillingAccount;

    /**
     * Nullable Id - Response Model.
     *
     * @var NullableIdResponse|null
     */
    protected $specificVeterinaryGroup;

    /**
     * @var int
     */
    protected $unitPriceWithoutVat;

    /**
     * @var int
     */
    protected $unitPriceWithVat;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    /**
     * The date of service delivery realisation.
     */
    public function getCompletionDate(): ?\DateTime
    {
        return $this->completionDate;
    }

    /**
     * The date of service delivery realisation.
     */
    public function setCompletionDate(?\DateTime $completionDate): self
    {
        $this->initialized['completionDate'] = true;
        $this->completionDate = $completionDate;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    /**
     * The date on which the invoice is to be generated.
     */
    public function getInvoiceDate(): ?\DateTime
    {
        return $this->invoiceDate;
    }

    /**
     * The date on which the invoice is to be generated.
     */
    public function setInvoiceDate(?\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getServiceDeliveryOption(): IdResponse
    {
        return $this->serviceDeliveryOption;
    }

    /**
     * Id - Response Model.
     */
    public function setServiceDeliveryOption(IdResponse $serviceDeliveryOption): self
    {
        $this->initialized['serviceDeliveryOption'] = true;
        $this->serviceDeliveryOption = $serviceDeliveryOption;

        return $this;
    }

    public function getShouldGenerateInvoice(): bool
    {
        return $this->shouldGenerateInvoice;
    }

    public function setShouldGenerateInvoice(bool $shouldGenerateInvoice): self
    {
        $this->initialized['shouldGenerateInvoice'] = true;
        $this->shouldGenerateInvoice = $shouldGenerateInvoice;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getSpecificBillingAccount(): ?NullableIdResponse
    {
        return $this->specificBillingAccount;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setSpecificBillingAccount(?NullableIdResponse $specificBillingAccount): self
    {
        $this->initialized['specificBillingAccount'] = true;
        $this->specificBillingAccount = $specificBillingAccount;

        return $this;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function getSpecificVeterinaryGroup(): ?NullableIdResponse
    {
        return $this->specificVeterinaryGroup;
    }

    /**
     * Nullable Id - Response Model.
     */
    public function setSpecificVeterinaryGroup(?NullableIdResponse $specificVeterinaryGroup): self
    {
        $this->initialized['specificVeterinaryGroup'] = true;
        $this->specificVeterinaryGroup = $specificVeterinaryGroup;

        return $this;
    }

    public function getUnitPriceWithoutVat(): int
    {
        return $this->unitPriceWithoutVat;
    }

    public function setUnitPriceWithoutVat(int $unitPriceWithoutVat): self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;

        return $this;
    }

    public function getUnitPriceWithVat(): int
    {
        return $this->unitPriceWithVat;
    }

    public function setUnitPriceWithVat(int $unitPriceWithVat): self
    {
        $this->initialized['unitPriceWithVat'] = true;
        $this->unitPriceWithVat = $unitPriceWithVat;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishment(): IdResponse
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishment(IdResponse $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
