<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $banner;

    /**
     * @var string|null
     */
    protected $customName;

    /**
     * @var int|null
     */
    protected $entryNumber;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $legalStructure;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $logo;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $mainBillingAccount;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string|null
     */
    protected $personalisedMention;

    /**
     * @var list<IdRequest>|null
     */
    protected $pictures;

    /**
     * @var string
     */
    protected $privilegedCode;

    /**
     * @var VeterinaryEstablishmentRequestSchedule
     */
    protected $schedule;

    /**
     * @var string
     */
    protected $serviceVatCategory;

    /**
     * @var string|null
     */
    protected $shortDescription;

    /**
     * @var string
     */
    protected $type;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getBanner(): ?NullableIdRequest
    {
        return $this->banner;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setBanner(?NullableIdRequest $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    public function getCustomName(): ?string
    {
        return $this->customName;
    }

    public function setCustomName(?string $customName): self
    {
        $this->initialized['customName'] = true;
        $this->customName = $customName;

        return $this;
    }

    public function getEntryNumber(): ?int
    {
        return $this->entryNumber;
    }

    public function setEntryNumber(?int $entryNumber): self
    {
        $this->initialized['entryNumber'] = true;
        $this->entryNumber = $entryNumber;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getLegalStructure(): IdRequest
    {
        return $this->legalStructure;
    }

    /**
     * Id - Common Request Model.
     */
    public function setLegalStructure(IdRequest $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getLogo(): ?NullableIdRequest
    {
        return $this->logo;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setLogo(?NullableIdRequest $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getMainBillingAccount(): ?NullableIdRequest
    {
        return $this->mainBillingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setMainBillingAccount(?NullableIdRequest $mainBillingAccount): self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getPersonalisedMention(): ?string
    {
        return $this->personalisedMention;
    }

    public function setPersonalisedMention(?string $personalisedMention): self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;

        return $this;
    }

    /**
     * @return list<IdRequest>|null
     */
    public function getPictures(): ?array
    {
        return $this->pictures;
    }

    /**
     * @param list<IdRequest>|null $pictures
     */
    public function setPictures(?array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    public function getPrivilegedCode(): string
    {
        return $this->privilegedCode;
    }

    public function setPrivilegedCode(string $privilegedCode): self
    {
        $this->initialized['privilegedCode'] = true;
        $this->privilegedCode = $privilegedCode;

        return $this;
    }

    public function getSchedule(): VeterinaryEstablishmentRequestSchedule
    {
        return $this->schedule;
    }

    public function setSchedule(VeterinaryEstablishmentRequestSchedule $schedule): self
    {
        $this->initialized['schedule'] = true;
        $this->schedule = $schedule;

        return $this;
    }

    public function getServiceVatCategory(): string
    {
        return $this->serviceVatCategory;
    }

    public function setServiceVatCategory(string $serviceVatCategory): self
    {
        $this->initialized['serviceVatCategory'] = true;
        $this->serviceVatCategory = $serviceVatCategory;

        return $this;
    }

    public function getShortDescription(): ?string
    {
        return $this->shortDescription;
    }

    public function setShortDescription(?string $shortDescription): self
    {
        $this->initialized['shortDescription'] = true;
        $this->shortDescription = $shortDescription;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }
}
