<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentMemberResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string|null
     */
    protected $accountingCode;

    /**
     * @var \DateTime
     */
    protected $entryDate;

    /**
     * @var \DateTime|null
     */
    protected $exitDate;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryEstablishment;

    /**
     * Id - Response Model.
     *
     * @var IdResponse
     */
    protected $veterinaryGroup;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getAccountingCode(): ?string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(?string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getEntryDate(): \DateTime
    {
        return $this->entryDate;
    }

    public function setEntryDate(\DateTime $entryDate): self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;

        return $this;
    }

    public function getExitDate(): ?\DateTime
    {
        return $this->exitDate;
    }

    public function setExitDate(?\DateTime $exitDate): self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryEstablishment(): IdResponse
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryEstablishment(IdResponse $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    /**
     * Id - Response Model.
     */
    public function getVeterinaryGroup(): IdResponse
    {
        return $this->veterinaryGroup;
    }

    /**
     * Id - Response Model.
     */
    public function setVeterinaryGroup(IdResponse $veterinaryGroup): self
    {
        $this->initialized['veterinaryGroup'] = true;
        $this->veterinaryGroup = $veterinaryGroup;

        return $this;
    }
}
