<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentCreditNoteRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var VeterinaryEstablishmentCreditNoteRequestBankAccount
     */
    protected $bankAccount;

    /**
     * Credit Note Category.
     *
     * @var string
     */
    protected $category;

    /**
     * @var list<VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem>
     */
    protected $creditNoteLines;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $creditor;

    /**
     * @var InvoiceAddressRequest
     */
    protected $deliveryAddress;

    /**
     * @var VeterinaryEstablishmentCreditNoteRequestDeliveryInformation
     */
    protected $deliveryInformation;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string
     */
    protected $paymentMethod;

    /**
     * @var string|null
     */
    protected $personalisedMention;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getBankAccount(): VeterinaryEstablishmentCreditNoteRequestBankAccount
    {
        return $this->bankAccount;
    }

    public function setBankAccount(VeterinaryEstablishmentCreditNoteRequestBankAccount $bankAccount): self
    {
        $this->initialized['bankAccount'] = true;
        $this->bankAccount = $bankAccount;

        return $this;
    }

    /**
     * Credit Note Category.
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * Credit Note Category.
     */
    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    /**
     * @return list<VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem>
     */
    public function getCreditNoteLines(): array
    {
        return $this->creditNoteLines;
    }

    /**
     * @param list<VeterinaryEstablishmentCreditNoteRequestCreditNoteLinesItem> $creditNoteLines
     */
    public function setCreditNoteLines(array $creditNoteLines): self
    {
        $this->initialized['creditNoteLines'] = true;
        $this->creditNoteLines = $creditNoteLines;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getCreditor(): IdRequest
    {
        return $this->creditor;
    }

    /**
     * Id - Common Request Model.
     */
    public function setCreditor(IdRequest $creditor): self
    {
        $this->initialized['creditor'] = true;
        $this->creditor = $creditor;

        return $this;
    }

    public function getDeliveryAddress(): InvoiceAddressRequest
    {
        return $this->deliveryAddress;
    }

    public function setDeliveryAddress(InvoiceAddressRequest $deliveryAddress): self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;

        return $this;
    }

    public function getDeliveryInformation(): VeterinaryEstablishmentCreditNoteRequestDeliveryInformation
    {
        return $this->deliveryInformation;
    }

    public function setDeliveryInformation(VeterinaryEstablishmentCreditNoteRequestDeliveryInformation $deliveryInformation): self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->initialized['paymentMethod'] = true;
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    public function getPersonalisedMention(): ?string
    {
        return $this->personalisedMention;
    }

    public function setPersonalisedMention(?string $personalisedMention): self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): IdRequest
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
