<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1PetGhostProfilesIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var \DateTime|null
     */
    protected $birthDate;

    /**
     * @var string|null
     */
    protected $freePetBreed;

    /**
     * @var string|null
     */
    protected $gender;

    /**
     * @var string|null
     */
    protected $name;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1PetGhostProfilesIdPatchBodyPetBreed|null
     */
    protected $petBreed;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1PetGhostProfilesIdPatchBodyProfilePicture|null
     */
    protected $profilePicture;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getBirthDate(): ?\DateTime
    {
        return $this->birthDate;
    }

    public function setBirthDate(?\DateTime $birthDate): self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;

        return $this;
    }

    public function getFreePetBreed(): ?string
    {
        return $this->freePetBreed;
    }

    public function setFreePetBreed(?string $freePetBreed): self
    {
        $this->initialized['freePetBreed'] = true;
        $this->freePetBreed = $freePetBreed;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->initialized['gender'] = true;
        $this->gender = $gender;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getPetBreed(): ?V1PetGhostProfilesIdPatchBodyPetBreed
    {
        return $this->petBreed;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setPetBreed(?V1PetGhostProfilesIdPatchBodyPetBreed $petBreed): self
    {
        $this->initialized['petBreed'] = true;
        $this->petBreed = $petBreed;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getProfilePicture(): ?V1PetGhostProfilesIdPatchBodyProfilePicture
    {
        return $this->profilePicture;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setProfilePicture(?V1PetGhostProfilesIdPatchBodyProfilePicture $profilePicture): self
    {
        $this->initialized['profilePicture'] = true;
        $this->profilePicture = $profilePicture;

        return $this;
    }
}
