<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1CustomerProfilesIdPatchBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1CustomerProfilesIdPatchBodyBillingContact|null
     */
    protected $billingContact;

    /**
     * @var \DateTime|null
     */
    protected $birthDate;

    /**
     * @var string|null
     */
    protected $birthName;

    /**
     * @var string|null
     */
    protected $companyDescription;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1CustomerProfilesIdPatchBodyDeliveryContact|null
     */
    protected $deliveryContact;

    /**
     * @var string|null
     */
    protected $firstname;

    /**
     * @var string|null
     */
    protected $gender;

    /**
     * @var string|null
     */
    protected $lastname;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1CustomerProfilesIdPatchBodyMainContact|null
     */
    protected $mainContact;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getBillingContact(): ?V1CustomerProfilesIdPatchBodyBillingContact
    {
        return $this->billingContact;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setBillingContact(?V1CustomerProfilesIdPatchBodyBillingContact $billingContact): self
    {
        $this->initialized['billingContact'] = true;
        $this->billingContact = $billingContact;

        return $this;
    }

    public function getBirthDate(): ?\DateTime
    {
        return $this->birthDate;
    }

    public function setBirthDate(?\DateTime $birthDate): self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;

        return $this;
    }

    public function getBirthName(): ?string
    {
        return $this->birthName;
    }

    public function setBirthName(?string $birthName): self
    {
        $this->initialized['birthName'] = true;
        $this->birthName = $birthName;

        return $this;
    }

    public function getCompanyDescription(): ?string
    {
        return $this->companyDescription;
    }

    public function setCompanyDescription(?string $companyDescription): self
    {
        $this->initialized['companyDescription'] = true;
        $this->companyDescription = $companyDescription;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getDeliveryContact(): ?V1CustomerProfilesIdPatchBodyDeliveryContact
    {
        return $this->deliveryContact;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setDeliveryContact(?V1CustomerProfilesIdPatchBodyDeliveryContact $deliveryContact): self
    {
        $this->initialized['deliveryContact'] = true;
        $this->deliveryContact = $deliveryContact;

        return $this;
    }

    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    public function setFirstname(?string $firstname): self
    {
        $this->initialized['firstname'] = true;
        $this->firstname = $firstname;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->initialized['gender'] = true;
        $this->gender = $gender;

        return $this;
    }

    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    public function setLastname(?string $lastname): self
    {
        $this->initialized['lastname'] = true;
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getMainContact(): ?V1CustomerProfilesIdPatchBodyMainContact
    {
        return $this->mainContact;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setMainContact(?V1CustomerProfilesIdPatchBodyMainContact $mainContact): self
    {
        $this->initialized['mainContact'] = true;
        $this->mainContact = $mainContact;

        return $this;
    }
}
