<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasVeterinaryEstablishmentServiceDiscountRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $accountingCode;

    /**
     * @var int|null
     */
    protected $amount;

    /**
     * @var string|null
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingCode(): ?string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(?string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getAmount(): ?int
    {
        return $this->amount;
    }

    public function setAmount(?int $amount): self
    {
        $this->initialized['amount'] = true;
        $this->amount = $amount;

        return $this;
    }

    public function getEntitled(): ?string
    {
        return $this->entitled;
    }

    public function setEntitled(?string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }
}
