<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ScheduleResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var list<OpeningPeriodResponse>|null
     */
    protected $monday;

    /**
     * @var list<OpeningPeriodResponse>|null
     */
    protected $tuesday;

    /**
     * @var list<OpeningPeriodResponse>|null
     */
    protected $wednesday;

    /**
     * @var list<OpeningPeriodResponse>|null
     */
    protected $thursday;

    /**
     * @var list<OpeningPeriodResponse>|null
     */
    protected $friday;

    /**
     * @var list<OpeningPeriodResponse>|null
     */
    protected $saturday;

    /**
     * @var list<OpeningPeriodResponse>|null
     */
    protected $sunday;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return list<OpeningPeriodResponse>|null
     */
    public function getMonday(): ?array
    {
        return $this->monday;
    }

    /**
     * @param list<OpeningPeriodResponse>|null $monday
     */
    public function setMonday(?array $monday): self
    {
        $this->initialized['monday'] = true;
        $this->monday = $monday;

        return $this;
    }

    /**
     * @return list<OpeningPeriodResponse>|null
     */
    public function getTuesday(): ?array
    {
        return $this->tuesday;
    }

    /**
     * @param list<OpeningPeriodResponse>|null $tuesday
     */
    public function setTuesday(?array $tuesday): self
    {
        $this->initialized['tuesday'] = true;
        $this->tuesday = $tuesday;

        return $this;
    }

    /**
     * @return list<OpeningPeriodResponse>|null
     */
    public function getWednesday(): ?array
    {
        return $this->wednesday;
    }

    /**
     * @param list<OpeningPeriodResponse>|null $wednesday
     */
    public function setWednesday(?array $wednesday): self
    {
        $this->initialized['wednesday'] = true;
        $this->wednesday = $wednesday;

        return $this;
    }

    /**
     * @return list<OpeningPeriodResponse>|null
     */
    public function getThursday(): ?array
    {
        return $this->thursday;
    }

    /**
     * @param list<OpeningPeriodResponse>|null $thursday
     */
    public function setThursday(?array $thursday): self
    {
        $this->initialized['thursday'] = true;
        $this->thursday = $thursday;

        return $this;
    }

    /**
     * @return list<OpeningPeriodResponse>|null
     */
    public function getFriday(): ?array
    {
        return $this->friday;
    }

    /**
     * @param list<OpeningPeriodResponse>|null $friday
     */
    public function setFriday(?array $friday): self
    {
        $this->initialized['friday'] = true;
        $this->friday = $friday;

        return $this;
    }

    /**
     * @return list<OpeningPeriodResponse>|null
     */
    public function getSaturday(): ?array
    {
        return $this->saturday;
    }

    /**
     * @param list<OpeningPeriodResponse>|null $saturday
     */
    public function setSaturday(?array $saturday): self
    {
        $this->initialized['saturday'] = true;
        $this->saturday = $saturday;

        return $this;
    }

    /**
     * @return list<OpeningPeriodResponse>|null
     */
    public function getSunday(): ?array
    {
        return $this->sunday;
    }

    /**
     * @param list<OpeningPeriodResponse>|null $sunday
     */
    public function setSunday(?array $sunday): self
    {
        $this->initialized['sunday'] = true;
        $this->sunday = $sunday;

        return $this;
    }
}
