<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ResourceTypeGetshort extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $friendlyName;

    /**
     * @var string
     */
    protected $slug;

    /**
     * @var string
     */
    protected $groupSlug;

    /**
     * @var string|null
     */
    protected $description;

    /**
     * @var bool
     */
    protected $prefixMandatory = true;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getFriendlyName(): string
    {
        return $this->friendlyName;
    }

    public function setFriendlyName(string $friendlyName): self
    {
        $this->initialized['friendlyName'] = true;
        $this->friendlyName = $friendlyName;

        return $this;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function setSlug(string $slug): self
    {
        $this->initialized['slug'] = true;
        $this->slug = $slug;

        return $this;
    }

    public function getGroupSlug(): string
    {
        return $this->groupSlug;
    }

    public function setGroupSlug(string $groupSlug): self
    {
        $this->initialized['groupSlug'] = true;
        $this->groupSlug = $groupSlug;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->initialized['description'] = true;
        $this->description = $description;

        return $this;
    }

    public function getPrefixMandatory(): bool
    {
        return $this->prefixMandatory;
    }

    public function setPrefixMandatory(bool $prefixMandatory): self
    {
        $this->initialized['prefixMandatory'] = true;
        $this->prefixMandatory = $prefixMandatory;

        return $this;
    }
}
