<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ResourceGroupGet extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $resourceType;

    /**
     * @var string
     */
    protected $slug;

    /**
     * @var string
     */
    protected $friendlyName;

    /**
     * @var string|null
     */
    protected $description;

    /**
     * @var list<string>
     */
    protected $resources;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getResourceType(): string
    {
        return $this->resourceType;
    }

    public function setResourceType(string $resourceType): self
    {
        $this->initialized['resourceType'] = true;
        $this->resourceType = $resourceType;

        return $this;
    }

    public function getSlug(): string
    {
        return $this->slug;
    }

    public function setSlug(string $slug): self
    {
        $this->initialized['slug'] = true;
        $this->slug = $slug;

        return $this;
    }

    public function getFriendlyName(): string
    {
        return $this->friendlyName;
    }

    public function setFriendlyName(string $friendlyName): self
    {
        $this->initialized['friendlyName'] = true;
        $this->friendlyName = $friendlyName;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->initialized['description'] = true;
        $this->description = $description;

        return $this;
    }

    /**
     * @return list<string>
     */
    public function getResources(): array
    {
        return $this->resources;
    }

    /**
     * @param list<string> $resources
     */
    public function setResources(array $resources): self
    {
        $this->initialized['resources'] = true;
        $this->resources = $resources;

        return $this;
    }
}
