<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PrincipalShort extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Email of the person to invite.
     *
     * @var string
     */
    protected $email;

    /**
     * Last name of the person.
     *
     * @var string|null
     */
    protected $lastname;

    /**
     * First name of the person.
     *
     * @var string|null
     */
    protected $firstname;

    /**
     * Locale to use. If not provided, detected during account validation.
     *
     * @var string|null
     */
    protected $locale;

    /**
     * Timezone to use. If not provided, detected during account validation.
     *
     * @var string|null
     */
    protected $timezone;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Email of the person to invite.
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * Email of the person to invite.
     */
    public function setEmail(string $email): self
    {
        $this->initialized['email'] = true;
        $this->email = $email;

        return $this;
    }

    /**
     * Last name of the person.
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * Last name of the person.
     */
    public function setLastname(?string $lastname): self
    {
        $this->initialized['lastname'] = true;
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * First name of the person.
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * First name of the person.
     */
    public function setFirstname(?string $firstname): self
    {
        $this->initialized['firstname'] = true;
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * Locale to use. If not provided, detected during account validation.
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * Locale to use. If not provided, detected during account validation.
     */
    public function setLocale(?string $locale): self
    {
        $this->initialized['locale'] = true;
        $this->locale = $locale;

        return $this;
    }

    /**
     * Timezone to use. If not provided, detected during account validation.
     */
    public function getTimezone(): ?string
    {
        return $this->timezone;
    }

    /**
     * Timezone to use. If not provided, detected during account validation.
     */
    public function setTimezone(?string $timezone): self
    {
        $this->initialized['timezone'] = true;
        $this->timezone = $timezone;

        return $this;
    }
}
